<?php

  //////////////////////////////////////////////////////////////
  ///
  ///  @class Maillist
  ///  @brief WebScriber Maillist class
  ///  @note  Copyright (c) 2005-2008 namesuppressed.
  ///
  ///  The mailing list class represents a single ezMLM mailing
  ///  list, complete with an id (the ezMLM name of the list), a
  ///  name (a human readable name that can be more verbose), a
  ///  description (for describing to prospective human
  ///  subscribers what the list is about) and a private flag
  ///  which toggles whether anyone can subscribe to the list or
  ///  if it is by invitation only.
  ///
  ///  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
  ///  KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
  ///  WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
  ///  PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
  ///  OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
  ///  OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  ///  OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
  ///  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
  ///
  //////////////////////////////////////////////////////////////



class Maillist {

  var $id;           ///< The ID of the mailing list
  var $name;         ///< Human readable name for the mailing list
  var $description;  ///< Description of what this mailing list is for
  var $private;      ///< Boolean, is this mailing list private?


	//////////////////////////////////////////////////////////////
	///  Default constructor for the Maillist class.
	///
	///  @return  A new Mailinglist object
	//////////////////////////////////////////////////////////////

  function Maillist() {
    $id = 'NoID';
    $name = 'No name';
    $description = 'No Description';
    $private = true;
    $subscribe = 'No subscribe address';
    $unsubscribe = 'No unsubscribe address';
  }



	//////////////////////////////////////////////////////////////
  ///  Set the ID for this mailing list
  ///
  ///  @param val  the ID for the mailing list
	//////////////////////////////////////////////////////////////

  function setID($val) {
    $this->id = $val;
  }



	//////////////////////////////////////////////////////////////
  ///  Set the human readable name for this mailing list
  ///
  ///  @param val  the name for the mailing list
	//////////////////////////////////////////////////////////////

  function setName($val) {
    $this->name = $val;
  }



	//////////////////////////////////////////////////////////////
	///  Set the detailed description for this mailing list
	///
	///  @param val  the description to give this mailing list
	//////////////////////////////////////////////////////////////

  function setDescription($val) {
    $this->description = $val;
  }



	//////////////////////////////////////////////////////////////
	///  Set whether this mailing list should be private or not.
	///  A private mailing list is one that cannot be seen
	///  unless the user is already a member of the list
	///
	///  @param val boolean of whether this list should be private
	//////////////////////////////////////////////////////////////

  function setPrivate($val) {
    $this->private = $val;
  }



	//////////////////////////////////////////////////////////////
	///  Set the email address users should send email to when
	///  subscribing to this mailing list
	///
	///  @param val the email address to use when subscribing
	//////////////////////////////////////////////////////////////

  function setSubscribeEmail($val) {
    $this->subscribe = $val;
  }



	//////////////////////////////////////////////////////////////
	///  Set the email address users should send email to when
	///  unsubscribing from this mailing list
	///
	///  @param val the email address to use when unsubscribing
	//////////////////////////////////////////////////////////////

  function setUnsubscribeEmail($val) {
    $this->unsubscribe = $val;
  }



	//////////////////////////////////////////////////////////////
	///  Get the ID for this mailing list 
	///
	///  @return a string with the mailing list ID
	//////////////////////////////////////////////////////////////

  function getID() {
    return $this->id;
  }



	//////////////////////////////////////////////////////////////
	///  Get the human readable name for this mailing list
	///
	///  @return a string with the mailing list name
	//////////////////////////////////////////////////////////////

  function getName() {
    return $this->name;
  }



	//////////////////////////////////////////////////////////////
	///  Get the detailed human readable description for this
	///  mailing list
	///
	///  @return a string with the mailing list description
	//////////////////////////////////////////////////////////////

  function getDescription() {
    return $this->description;
  }



	//////////////////////////////////////////////////////////////
	///  Get the email address users should email to subscribe
	///  to this mailing list
	///
	///  @return true if this mailing list is private, or false
	///          otherwise
	//////////////////////////////////////////////////////////////

  function isPrivate() {
    return $this->private;
  }


  
	//////////////////////////////////////////////////////////////
	///  Get the email address users should email to subscribe
	///  to this mailing list
	///
	///  @return the email address to use when subscribing
	//////////////////////////////////////////////////////////////

  function getSubscribeEmail($val) {
    return $this->subscribe;
  }



	//////////////////////////////////////////////////////////////
	///  Get the email address users should email to unsubscribe
	///  from this mailing list
	///
	///  @return the email address to use when unsubscribing
	//////////////////////////////////////////////////////////////

  function getUnsubscribeEmail($val) {
    return $this->unsubscribe;
  }



	//////////////////////////////////////////////////////////////
	///  Returns a string representation of this object
	///
	///  @return a string representing this maillist object
	//////////////////////////////////////////////////////////////

  function toString() {
    $result  = '';
    $result .= "[" . $this->getID() . "]\n";
    $result .= "NAME=\"" . $this->getName() . "\"\n";
    $result .= "DESCRIPTION=\"" . $this->getDescription() . "\"\n";
    $result .= "PRIVATE=\"";
    if ($this->isPrivate()) {
      $result .= "true";
    }
    else $result .= "false";
    $result .= "\"\n";
    $result .= "SUBSCRIBE=\"" . $this->getSubscribeEmail() . "\"\n";
    $result .= "UNSUBSCRIBE=\"" . $this->getUnsubscribeEmail() . "\"\n";
    return $result;
  }
}